//=============================================================================
// MSMTLTeam, no difference other custom players.
//
// 
//=============================================================================
class BroopSiege extends MTLTeam; 

var class<MTLPlayer> UnatcoClassName;
var class<MTLPlayer> NsfClassName;

var name UnatcoClass;
var name NsfClass;

var int CurWave;

replication
{
   reliable if (Role == ROLE_Authority)
      ShowMessage;
} 

simulated function ShowMessage(DeusExPlayer Player, string Message)
{
  local HUDMissionStartTextDisplay    HUD;
  if ((Player.RootWindow != None) && (DeusExRootWindow(Player.RootWindow).HUD != None))
  {
    HUD = DeusExRootWindow(Player.RootWindow).HUD.startDisplay;
  }
  if(HUD != None)
  {
    HUD.shadowDist = 0;
    HUD.Message = "";
    HUD.charIndex = 0;
    HUD.winText.SetText("");
    HUD.winTextShadow.SetText("");
    HUD.displayTime = 5.50;
    HUD.perCharDelay = 0.30;
    HUD.AddMessage(Message);
    HUD.StartMessage();
  }
}


function string GetExcuse()
{
 local int R;
 
 R = Rand(10);
 
 switch(R)
 {
  case 0:
   return " by opening a can of whoopass!";
  break;
  case 1:
   return " using a helping of lead salad!";
  break;
  case 2:
   return " with some professional cunt punting!";
  break;
  case 3:
   return " via supreme skull fucking!";
  break;
  case 4:
   return " by sheer luck!";
  break;
  case 5:
   return " using raw numbers!";
  break;
  case 6:
   return " with a 7200 dank scoping!";
  break;
  case 7:
   return " by not touching fucking swords!";
  break;
  case 8:
   return " with god damn slugger spam!";
  break;
  case 9:
   return " using his psychic powers!";
  break;
 }
 
 return " by opening a can of whoopass!";
}

function bool AllHopeLost()
{
 local bool bLost;
 local MSMTLPlayer DXP;
 
 local Pawn CurPawn;
 local int K;
 
 bLost = True;
 k = 0;
 
 if (!NotBreakPeriod()) return false;
 
 forEach AllActors(class'MSMTLPlayer', DXP)
 {
  k++;
  //if (DXP.LivesLeft > 0) bLost = False;
  if (IsLiving(DXP)) bLost = False;
 }
 
 if (bLost && k > 0)
 {
  PreGameOver();
  curPawn = Level.PawnList;
  while ( curPawn != None )
  {
	if ( curPawn.IsA('DeusExPlayer') )
	{
		DeusExPlayer(curPawn).ShowMultiplayerWin( "Non-players", 1, "Bot", "Player", GetExcuse() );
	}
	curPawn = curPawn.nextPawn;
  }
  GameOver();
 }
 
 return bLost;
}

function bool NotBreakPeriod()
{
 local Mutator Mu;
 local int BreakW, SpawnW;
 
 forEach AllActors(Class'Mutator', Mu)
 {
  if (Mu.IsA('BroopSiegeMutator'))
  {
   BreakW = int(Mu.GetPropertyText("LastBreakWave"));
   SpawnW = int(Mu.GetPropertyText("LastSpawnWave"));
   //Log("COMPARING"@BreakW@SpawnW@(BreakW == SpawnW));
   return !(BreakW == SpawnW);
  }
 }
 
 return false;
}

function bool IsLiving(Actor CS)
{
 if (CS == None) return False;
 
 if (CS.IsInState('Dying')) return False;
 if (CS.IsInState('Spectating')) return False;
 if (CS.IsInState('CheatFlyingButDead')) return False;
 if (DeusExPlayer(CS).ReducedDamageType == 'All') return False;
 
 return True;
}

function DeusExPlayer GetLivingPlayer()
{
 local DeusExPlayer DXP;
 
 forEach AllActors(class'DeusExPlayer', DXP)
 {
  if (IsLiving(DXP))
  {
   return DXP;
  }
 }
 
 return None;
}

function bool RestartPlayer( pawn aPlayer )	
{
    local DeusExPlayer PlayerToRestart;
    local bool SuperResult;

    log("DeusEx Multiplayer Game restart player");
    PlayerToRestart = DeusExPlayer(aPlayer);

    if (PlayerToRestart == None)
    {
        log("Trying to restart non Deus Ex player!");
        return false;
    }
    
    if ((MSMTLPlayer(aPlayer) != None) && (CurWave > 0))
    {
	if (!AllHopeLost())
	{
	}
     	   //MSMTLPlayer(aPlayer).GoToState('Spectating');
     	//return False;
	//return True;
    }
    if (MSMTLPlayer(aPlayer) != None && (InStr(CAPS(GetURLMap()), "00_FIRINGRANGE3") <= -1))
    {
	MSMTLPlayer(aPlayer).LivesLeft -= 1;
	//if (MSMTLPlayer(aPlayer).LivesLeft > 0) ShowMessage(MSMTLPlayer(aPlayer), MSMTLPlayer(aPlayer).LivesLeft@"Lives Remaining!");
	//if (MSMTLPlayer(aPlayer).LivesLeft == 0) ShowMessage(MSMTLPlayer(aPlayer), "|p2LAST LIFE!");
	//if (MSMTLPlayer(aPlayer).LivesLeft < 0) ShowMessage(MSMTLPlayer(aPlayer), "U DED.");
	
	//aPlayer.ClientMessage("|p4"$aPlayer.GetPropertyText("LivesLeft")@"Lives Left!");
    }
    
    //Restore HUD    
    PlayerToRestart.ShowHud(True);
    //Clear Augmentations
    PlayerToRestart.AugmentationSystem.ResetAugmentations();
    //Clear Skills
    PlayerToRestart.SkillSystem.ResetSkills();
    
    //DEUS_EX AMSD For some reason, reset player to defaults doesn't do all of the spiffy things that it should...
    //so some of it will be doneon the side
    PlayerToRestart.ResetPlayerToDefaults();
    
    SuperResult = Super.RestartPlayer(aPlayer);       
    
    //Restore Augs
    PlayerToRestart.ClearAugmentationDisplay();
    PlayerToRestart.AugmentationSystem.CreateAugmentations(PlayerToRestart);
    PlayerToRestart.AugmentationSystem.AddDefaultAugmentations();
    //Restore Bio-Energy
    PlayerToRestart.Energy = PlayerToRestart.EnergyMax;
    //Restore Skills
    PlayerToRestart.SkillSystem.CreateSkills(PlayerToRestart);
    //Replace with skill points based on game info.
    SetupAbilities(PlayerToRestart);

	 PlayerToRestart.myProjKiller = None;

    return SuperResult;
}

//
// Return the 'best' player start for this player to start from.
// Re-implement for each game type.
//
function NavigationPoint FindPlayerStart( Pawn Player, optional byte InTeam, optional string incomingName )
{
	local PlayerStart Dest;
	local Teleporter Tel;
	
	local PathNode PN;
	
	//NEW CODE FOR ANTI FRAG!
	
	if (Level.Netmode == NM_Standalone) return Super.FindPlayerStart(Player, InTeam, incomingName);
	


	//foreach AllActors( class 'PlayerStart', Dest )
	Dest = PlayerStart(ObtainRandom(class'PlayerStart'));
	if (Dest != None)
	{
	 PN = FindClosestNode(Dest);
	 
	 if (PN != None)
	  return PN;
	}
	
	if( incomingName!="" )
		foreach AllActors( class 'Teleporter', Tel )
			if( string(Tel.Tag)~=incomingName )
				return Tel;
	foreach AllActors( class 'PlayerStart', Dest )
		if( Dest.bSinglePlayerStart && Dest.bEnabled )
			return Dest;

	// if none, check for any that aren't enabled
	log("WARNING: All single player starts were disabled - picking one anyway!");
	foreach AllActors( class 'PlayerStart', Dest )
		if( Dest.bSinglePlayerStart )
			return Dest;
	log( "No single player start found" );
	return None;
}



//Supports up to 128 scale!
function Actor ObtainRandom(class<Actor> Act)
{
 local Actor A;
 local int Count;
 local Actor TA[128];
 local SiegeSpawnPoint SP;
 
 forEach AllActors(Act, A)
 {
  if (A != None)
  {
   SP = SiegeSpawnPoint(A);
   
   if (SP == None)
   {
    TA[Count] = A;
    Count++;
   }
   else if (SP.MyTag ~= "")
   {
    TA[Count] = A;
    Count++;
   }
  }
 }
 
 return TA[Rand(Count)];
}

function PathNode FindClosestNode(PlayerStart P)
{
	local PathNode Nodes, BestNode;
	local float BestDist;
	local DeusExPlayer CheckP;
	local int j;
	
	local Teleporter TP;
	local MapExit ME;
	
	if (P == None) return None;
	
	BestDist = 99999;
	
	forEach AllActors(class'PathNode', Nodes)
	{
	 if (VSize(P.Location - Nodes.Location) < BestDist)
	 {
	  j = 0;
	  forEach RadiusActors(class'DeusExPlayer', CheckP, 40, Nodes.Location)
	   if (CheckP != None && CheckP != P) j++;
	  
	  forEach RadiusActors(class'Teleporter', TP, 80, P.Location)
	   j++;

	  forEach RadiusActors(class'MapExit', ME, 80, P.Location)
	   j++;
	  
	  if (j == 0)
	  {
	   BestNode = Nodes;
	   BestDist = VSize(P.Location - Nodes.Location);
	  }
	 }
	}
	
	if (BestNode != None) return BestNode;
	
	return None;
}



function bool ChangeTeam (Pawn Z61, int NewTeam)
{
	local Class<MTLPlayer> Z62;
	local MTLPlayer Z63;

	if (  !ApproveTeam(NewTeam) )
	{
		NewTeam=128;
	}
	if ( NewTeam == 128 )
	{
		if ( PlayerPawn(Z61) != None )
		{
			NewTeam=PlayerPawn(Z61).PlayerReplicationInfo.Team;
		} else {
			return False;
		}
	}
	if (  !Super(DeusExMPGame).ChangeTeam(Z61,NewTeam) )
	{
		return False;
	}
	Z63=MTLPlayer(Z61);
	if ( Z63 == None )
	{
		return False;
	}
	if ( NewTeam == 0 )
	{
		Z62=UnatcoClassName;
	} else {
		if ( NewTeam == 1 )
		{
			Z62=NsfClassName;
		} else {
			return False;
		}
	}
	return True;
}

// ---------------------------------------------------------------------
// Override login so we can specify our own player classes
// ---------------------------------------------------------------------
event PlayerPawn Login(string Portal, string Options, out string Error,
		       class<playerpawn> SpawnClass)
{
   local DeusExPlayer player;
   local NavigationPoint StartSpot;
   local byte InTeam;
   local DumpLocation dump;
   local int TeamOption;

   TeamOption = TEAM_UNATCO;
   if (HasOption(Options,"Team"))
   {
      TeamOption = int(ParseOption(Options,"Team"));
   }

   if (TeamOption == TEAM_AUTO)
      TeamOption = GetAutoTeam();

   if (TeamOption == TEAM_UNATCO)
      SpawnClass = UnatcoClassName;

   else if (TeamOption == TEAM_NSF)
      SpawnClass = NsfClassName;

   ChangeOption(Options, "Team", string(TeamOption));

   // Can't call Super.Login here since that forces a particular class, so
   //  we cut and paste the code (horribly breaks compatibility, but we
   //  really have no choice)

   ///////////////////////////////////////////////////////////////////////////
   // Login from DeusExMPGame
   if ((MaxPlayers > 0) && (NumPlayers >= MaxPlayers) )
   {
     Error = TooManyPlayers;
     return None;
   }

   ///////////////////////////////////////////////////////////////////////////
   // Login from DeusExGameInfo

   // We SKIP over all of the other Login() calls and go directly to GameInfo
   //  so that we can miss all the IS bogocity
   player = DeusExPlayer(Super(GameInfo).Login(Portal, Options, Error, SpawnClass));

   // If we're traveling across a map on the same mission, 
   // nuke the player's crap and 
   
   if ((player != None) && (!HasOption(Options, "Loadgame")))
   {
     player.ResetPlayerToDefaults();
     
     dump = player.CreateDumpLocationObject();

     if ((dump != None) && (dump.HasLocationBeenSaved()))
     {
       dump.LoadLocation();

       player.Pause();
       player.SetLocation(dump.currentDumpLocation.Location);
       player.SetRotation(dump.currentDumpLocation.ViewRotation);
       player.ViewRotation = dump.currentDumpLocation.ViewRotation;
       player.ClientSetRotation(dump.currentDumpLocation.ViewRotation);
       
       CriticalDelete(dump);
     }
     else
     {
       // Multiplayer now, defaults to Team_Unatco=0
       InTeam    = GetIntOption( Options, "Team", 0 );

       if (Level.NetMode == NM_Standalone)			
	 StartSpot = FindPlayerStart( None, InTeam, Portal );
       else
	 StartSpot = FindPlayerStart( Player, InTeam, Portal );

       player.SetLocation(StartSpot.Location);
       player.SetRotation(StartSpot.Rotation);
       player.ViewRotation = StartSpot.Rotation;
       player.ClientSetRotation(player.Rotation);
     }
   }

   player.bAutoActivate = true;

   return player;
}



defaultproperties
{
    UnatcoClassName=Class'MSMTLUNATCO'
    NsfClassName=Class'MSMTLNSF'
    DefaultPlayerClass=Class'MSMTLUNATCO'
    TeamNsfString="Team Rote Spades"
    TeamUnatcoString="Team Blackherz"
}
